//Ported from MPC-HC sharpen complex 2.

/*
[configuration]

[OptionBool]
GUIName = Sharpen
OptionName = SHARP
DefaultValue = true

[OptionRangeFloat]
GUIName = Edge (0.2)
OptionName = edge
MinValue = 0.00
MaxValue = 1.0
StepAmount = 0.01
DefaultValue = 0.2
DependentOption = SHARP

[OptionRangeFloat]
GUIName = Value (2)
OptionName = value
MinValue = 1
MaxValue = 3
StepAmount = 0.1
DefaultValue = 2
DependentOption = SHARP

[OptionRangeFloat]
GUIName = Blur (2)
OptionName = blur
MinValue = 1
MaxValue = 5
StepAmount = 0.1
DefaultValue = 2
DependentOption = SHARP

[OptionRangeFloat]
GUIName = Mean (0.6)
OptionName = mean
MinValue = 0
MaxValue = 1
StepAmount = 0.01
DefaultValue = 0.6
DependentOption = SHARP

[/configuration]
*/

// pixel "width". Internal res work?
float px = GetInvResolution().x;
float py = GetInvResolution().y;
//float px = 1/1920; //(textureSize(samp9, 0).x);
//float py = 1/1584; //(textureSize(samp9, 0).y);
// Parameters
// for the blur filter

float dx = (GetOption(mean)*px);
float dy = (GetOption(mean)*py);

float CoefBlur = GetOption(blur);
float SharpenEdge = GetOption(edge);
float Sharpen_val0 = GetOption(value);
float Sharpen_val1 = ((Sharpen_val0 - 1) / 8.0);

void main() {
float3 color = Sample().xyz;
if (OptionEnabled(SHARP)) {
float3 orig = color;
float3 c1 = SampleLocation(GetCoordinates() + float2(-dx, -dy)).xyz;
float3 c2 = SampleLocation(GetCoordinates() + float2( 0, -dy)).xyz;
float3 c3 = SampleLocation(GetCoordinates() + float2( dx, -dy)).xyz;
float3 c4 = SampleLocation(GetCoordinates() + float2(-dx, 0)).xyz;
float3 c5 = SampleLocation(GetCoordinates() + float2( dx, 0)).xyz;
float3 c6 = SampleLocation(GetCoordinates() + float2(-dx, dy)).xyz;
float3 c7 = SampleLocation(GetCoordinates() + float2( 0, dy)).xyz;
float3 c8 = SampleLocation(GetCoordinates() + float2( dx, dy)).xyz;


float3 flou = (c1 + c3 + c6 + c8 + 2 * (c2 + c4 + c5 + c7) + 4 * orig) * 0.0625;
float3 corrected = (1 + CoefBlur) * orig - CoefBlur * flou;

c1 = SampleLocation(GetCoordinates() + float2(-px, -py)).xyz;
c2 = SampleLocation(GetCoordinates() + float2( 0, -py)).xyz;
c3 = SampleLocation(GetCoordinates() + float2( px, -py)).xyz;
c4 = SampleLocation(GetCoordinates() + float2(-px, 0)).xyz;
c5 = SampleLocation(GetCoordinates() + float2( px, 0)).xyz;
c6 = SampleLocation(GetCoordinates() + float2(-px, py)).xyz;
c7 = SampleLocation(GetCoordinates() + float2( 0, py)).xyz;
c8 = SampleLocation(GetCoordinates() + float2( px, py)).xyz;

float delta1 = dot(((c3 + 2 * c5 + c8) - (c1 + 2 * c4 + c6)).xyz, float3(0.2126729, 0.7151522, 0.0721750));  // For checking luminosity for edge. Is there a better way?
c1 += c3;
c6 += c8;
float delta2 = dot(((c6 + 2 * c7) - (c1 + 2 * c2)).xyz, float3(0.2126729, 0.7151522, 0.0721750));

color = corrected;

float compdet = sqrt(delta1*delta1 + delta2*delta2);
if (compdet > SharpenEdge) {
color =  (orig * Sharpen_val0 - (c1 + c2 + c4 + c5 + c6 + c7) * Sharpen_val1);}

} 
SetOutput(float4(color, 1.0));
}